#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "setupdlg.h"
#include "qcap.h"
#include "qcap.windef.h"

#define DEF_MAX_DEV 8

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void HwInitialize();

    void HwUninitialize();

private:
    Ui::MainWindow *ui;

public slots:
    void SetUpDialogSlot_VideoInput();

    void SetUpDialogSlot_AudioInput();

    void SetUpDialogSlot_Snapshot_BMP();

    void SetUpDialogSlot_Snapshot_JPG();

    void SetUpDialogSlot_VideoQuality();

    void SetUpDialogSlot_FileRecord();

    void SetUpDialogSlot_ShareRecord();


public:
        setupdlg        *m_setupdlg;

    /* DEVICE INFO */

        PVOID           m_hVideoDevice[DEF_MAX_DEV];

        PVOID			m_hCloneCapDev[DEF_MAX_DEV];

        ULONG           m_nVideoInput[DEF_MAX_DEV];

        ULONG           m_nAudioInput[DEF_MAX_DEV];

        QString         str_info[DEF_MAX_DEV];

        QString         path;

    /* VIDEO INFO */

        ULONG           m_nVideoWidth[DEF_MAX_DEV];

        ULONG           m_nVideoHeight[DEF_MAX_DEV];

        bool            m_bVideoIsInterleaved[DEF_MAX_DEV];

        double          m_dVideoFrameRate[DEF_MAX_DEV];

    /* ADUIO INFO */

        ULONG           m_nAudioChannels[DEF_MAX_DEV];

        ULONG           m_nAudioBitsPerSample[DEF_MAX_DEV];

        ULONG           m_nAudioSampleFrequency[DEF_MAX_DEV];

    /* SHARE RECORD */

        ULONG           m_nShareRecordCH;

        BOOL            m_bIsShareRecord;

    /* OTHER */

        BOOL			m_bFullScreen;

        ULONG           m_nCurChannel;
};

#endif // MAINWINDOW_H
